﻿uses GraphABC;

procedure DrawBhaskaraGraph();
var
  x0, y0, scale: integer;
  
  // Функция левой части минус 68: f(n) = ((n*5 - n*5/3)/10 + n/3 + n/2 + n/4) - 68
  function f(n: real): real;
  begin
    Result := ((n*5 - n*5/3)/10 + n/3 + n/2 + n/4) - 68;
  end;
  
  // Упрощенная функция: f(n) = 17n/12 - 68
  function f_simple(n: real): real;
  begin
    Result := (17*n)/12 - 68;
  end;
  
begin
  // Настройки окна
  Window.Title := ' Индийское число граф';
  Window.SetSize(800, 500);
  Window.CenterOnScreen;
  
  // Фон
  Brush.Color := Color.White;
  FillRectangle(0, 0, Window.Width, Window.Height);
  
  // Начало координат и масштаб
  x0 := 100;    // Отступ слева
  y0 := 400;    // Нулевая линия по Y (f(n) = 0)
  scale := 6;   // Пикселей на единицу
  
  // Рисуем ось X (значения n)
  Pen.Color := Color.Black;
  Pen.Width := 2;
  Line(50, y0, Window.Width - 50, y0);
  
  // Подписи на оси X
  for var i := 0 to 100 do
    if i mod 10 = 0 then
    begin
      var xpos := x0 + i * scale;
      // Отметки
      Line(xpos, y0 - 5, xpos, y0 + 5);
      // Числа
      if i = 48 then
      begin
        Font.Color := Color.Red;
        Font.Style := fsBold;
      end
      else
      begin
        Font.Color := Color.Black;
        Font.Style := fsNormal;
      end;
      TextOut(xpos - 8, y0 + 10, i.ToString);
    end;
  
  Font.Color := Color.Black;
  TextOut(Window.Width - 40, y0 + 10, 'n');
  TextOut(x0 + 300, y0 + 30, 'Искомое число n');
  
  // Рисуем ось Y (значения f(n))
  Line(x0, 50, x0, Window.Height - 50);
  
  // Подписи на оси Y
  for var i := -80 to 80 do
    if i mod 20 = 0 then
    begin
      var ypos := y0 - i * scale;
      // Отметки
      Line(x0 - 5, ypos, x0 + 5, ypos);
      // Числа
      TextOut(x0 - 25, ypos - 8, i.ToString);
    end;
  TextOut(x0 - 20, 40, 'f(n)');
  
  // Рисуем прямую f(n) = 17n/12 - 68
  Pen.Color := Color.Blue;
  Pen.Width := 3;
  
  var first := true;
  for var i := 0 to 100 do
  begin
    var n := i;
    var y := f_simple(n);
    var xpos := x0 + n * scale;
    var ypos := y0 - Round(y * scale);
    
    if first then
    begin
      MoveTo(xpos, ypos);
      first := false;
    end
    else
      LineTo(xpos, ypos);
  end;
  
  // Отмечаем корень уравнения f(n) = 0
  var root := 48;
  var y_root := f_simple(root); // = 0
  var xpos_root := x0 + root * scale;
  var ypos_root := y0 - Round(y_root * scale);
  
  // Красная точка - решение
  Pen.Color := Color.Red;
  Pen.Width := 6;
  Circle(xpos_root, ypos_root, 8);
  
  // Вертикальная пунктирная линия к оси X
  Pen.Color := Color.Gray;
  Pen.Width := 1;
  Pen.Style := psDash;
  Line(xpos_root, ypos_root, xpos_root, y0);
  Pen.Style := psSolid;
  
  // Подпись корня
  Brush.Color := Color.White;
  Pen.Color := Color.Red;
  Font.Size := 12;
  Font.Style := fsBold;
  Font.Color := Color.Red;
  TextOut(xpos_root - 15, ypos_root - 30, 'n = 48');
  
  // Уравнение в углу
  Brush.Color := Color.LightYellow;
  FillRectangle(10, 10, 500, 120);
  Pen.Color := Color.Black;
  Rectangle(10, 10, 500, 120);
  
  Font.Size := 11;
  Font.Color := Color.Black;
  Font.Style := fsBold;
  TextOut(20, 15, 'Уравнение:');
  Font.Style := fsNormal;
  TextOut(20, 35, '((n×5 - n×5/3) / 10) + n/3 + n/2 + n/4 = 68');
  TextOut(20, 55, 'После упрощения: 17n/12 = 68');
  TextOut(20, 75, 'Решение: n = 68 × 12 ÷ 17 = 48');
  Font.Size := 10;
  TextOut(20, 95, 'Проверка: подставьте n=48 в исходное уравнение');
  
  // Пошаговое вычисление для n=48
  Brush.Color := Color.LightCyan;
  FillRectangle(Window.Width - 350, 10, Window.Width - 10, 160);
  Pen.Color := Color.Black;
  Rectangle(Window.Width - 350, 10, Window.Width - 10, 160);
  
  Font.Size := 10;
  Font.Color := Color.Black;
  TextOut(Window.Width - 340, 15, 'Пошаговый расчёт для n=48:');
  TextOut(Window.Width - 340, 30, '1. n×5 = 48×5 = 240');
  TextOut(Window.Width - 340, 45, '2. n×5/3 = 240/3 = 80');
  TextOut(Window.Width - 340, 60, '3. 240 - 80 = 160');
  TextOut(Window.Width - 340, 75, '4. 160 / 10 = 16');
  TextOut(Window.Width - 340, 90, '5. n/3 = 48/3 = 16');
  TextOut(Window.Width - 340, 105, '6. n/2 = 48/2 = 24');
  TextOut(Window.Width - 340, 120, '7. n/4 = 48/4 = 12');
  TextOut(Window.Width - 340, 135, '8. Сумма: 16 + 16 + 24 + 12 = 68 ✓');
  
  // Легенда графика
  Brush.Color := Color.White;
  FillRectangle(Window.Width - 350, 180, Window.Width - 10, 230);
  Pen.Color := Color.Black;
  Rectangle(Window.Width - 350, 180, Window.Width - 10, 250);
  
  TextOut(Window.Width - 340, 185, 'Легенда:');
  Pen.Color := Color.Blue;
  Line(Window.Width - 340, 205, Window.Width - 300, 205);
  TextOut(Window.Width - 295, 200, 'f(n) = 17n/12 - 68');
  
  Pen.Color := Color.Red;
  Circle(Window.Width - 320, 225, 4);
  TextOut(Window.Width - 295, 220, 'Решение: f(48) = 0');
end;

begin
  DrawBhaskaraGraph();
end.